function [ game_config positions] = game_extraction( image_in, board_boundaries )
%GAME_EXTRACTION Summary of this function goes here
%   this function detects the position of the pieces in the image 
%   and correlates this information with the detectected board boundaries
%   in order to create an 8x8 matrix containg the game state information

%% Constant definitions

% Symbols
FREE = 16;
WHITE_M = 5;
BLACK_M = 6;
WHITE_K = 9;
BLACK_K = 10;

% Board boundary flags
X1 = 1;
Y1 = 2;
X2 = 3;
Y2 = 4;

board_size = 8;

maxPieces = 24;
actPieces =0;
positions = zeros(maxPieces,4);
%game_config = ones(board_size,board_size) * FREE;

game_config = [16 0 16 0 16 0 16 0;
               0 16 0 16 0 16 0 16;
               16 0 16 0 16 0 16 0;
               0 16 0 16 0 16 0 16;
               16 0 16 0 16 0 16 0;
               0 16 0 16 0 16 0 16;
               16 0 16 0 16 0 16 0;
               0 16 0 16 0 16 0 16];


[r c] = size(board_boundaries);

% detect pieces only found on the detected board
image = image_in((board_boundaries(1,2)-10) : (board_boundaries(9,2)+10), (board_boundaries(1,1)-10) : (board_boundaries(9,1)+10), :);

blockSize =  double((max(max(diff(board_boundaries))) + min(min(diff(board_boundaries))))/2);



%% Image Processing

[ m_white m_black m_w_king m_b_king ] = get_all_markers( image );

% figure(3)
% subplot(2,3,1);
% imshow(image);
% subplot(2,3,2);
% imshow(m_white);
% subplot(2,3,3);
% imshow(m_black);
% subplot(2,3,4);
% imshow(m_w_king);
% subplot(2,3,5);
% imshow(m_b_king);


[centroids_wm] = find_centroids(m_white);
[centroids_bm] = find_centroids(m_black);
[centroids_wk] = find_centroids(m_w_king);
[centroids_bk] = find_centroids(m_b_king);



%% Translate centroids

% % Set positions on the board function
%     function [ n ] = place_players (coords, type)
%         [r c] = size(coords);
%         for i = 1:r
%             if (coords(i,2) > 0) && (coords(i,1) >0)
%                 game_config(coords(i,2),coords(i,1)) = type;
%             end
%         end
%     end


% Set positions on the board function
    function [ n ] = place_players (coords_88, coords_pixel, type)
        [r c] = size(coords_88);
        for i = 1:r
            if (coords_88(i,2) > 0) && (coords_88(i,1) >0) && (coords_88(i,2) <= 8) && (coords_88(i,1) <= 8) && (game_config(coords_88(i,2),coords_88(i,1)) == 0)
                actPieces = actPieces + 1;
                game_config(coords_88(i,2),coords_88(i,1)) = type;
                if (actPieces <= maxPieces)
                    positions(actPieces, 1) = coords_pixel(i,2) + (board_boundaries(1,2)-10); 
                    positions(actPieces, 2) = coords_pixel(i,1) + (board_boundaries(1,1)-10);
                    positions(actPieces, 3) = coords_88(i,2);
                    positions(actPieces, 4) = coords_88(i,1);
                end
            end
        end
    end


if sum(size(centroids_wm)) >= 1
%     centroids_wm2(:,1) = ceil((centroids_wm(:,1) - board_boundaries(1,1))/blockSize);
%     centroids_wm2(:,2) = ceil((centroids_wm(:,2) - board_boundaries(1,2))/blockSize);
    centroids_wm2(:,1) = ceil((centroids_wm(:,1) - 10 )/blockSize);
    centroids_wm2(:,2) = ceil((centroids_wm(:,2) - 10)/blockSize);
    place_players(centroids_wm2, centroids_wm, WHITE_M);
end

if sum(size(centroids_bm)) >= 1
%     centroids_bm2(:,1) = ceil((centroids_bm(:,1) - board_boundaries(1,1))/blockSize);
%     centroids_bm2(:,2) = ceil((centroids_bm(:,2) - board_boundaries(1,2))/blockSize);
    centroids_bm2(:,1) = ceil((centroids_bm(:,1) - 10)/blockSize);
    centroids_bm2(:,2) = ceil((centroids_bm(:,2) - 10)/blockSize);
    place_players(centroids_bm2, centroids_bm,BLACK_M);
end

if sum(size(centroids_wk)) >= 1
%     centroids_wk2(:,1) = ceil((centroids_wk(:,1) - board_boundaries(1,1))/blockSize);
%     centroids_wk2(:,2) = ceil((centroids_wk(:,2) - board_boundaries(1,2))/blockSize);
    centroids_wk2(:,1) = ceil((centroids_wk(:,1) - 10)/blockSize);
    centroids_wk2(:,2) = ceil((centroids_wk(:,2) - 10)/blockSize);
    place_players(centroids_wk2, centroids_wk,WHITE_K);
end

if sum(size(centroids_bk)) >= 1
%     centroids_bk2(:,1) = ceil((centroids_bk(:,1) - board_boundaries(1,1))/blockSize);
%     centroids_bk2(:,2) = ceil((centroids_bk(:,2) - board_boundaries(1,2))/blockSize);
    centroids_bk2(:,1) = ceil((centroids_bk(:,1) - 10)/blockSize);
    centroids_bk2(:,2) = ceil((centroids_bk(:,2) - 10)/blockSize);
    place_players(centroids_bk2, centroids_bk,BLACK_K);
end


% game_config;
% figure(1)


end

